<?php
/**
 * Custom template tags for this theme.
 *
 * Eventually, some of the functionality here could be replaced by core features
 *
 * @package Snaps
 */

if ( ! function_exists( 'snaps_paging_nav' ) ) :
/**
 * Display navigation to next/previous set of posts when applicable.
 *
 * @return void
 */
function snaps_paging_nav( $max_num_pages = '' ) {
	// Get max_num_pages if not provided
	if ( '' == $max_num_pages ) {
		$max_num_pages = $GLOBALS['wp_query']->max_num_pages;
	}
	// Don't print empty markup if there's only one page.
	if ( $max_num_pages < 2 ) {
		return;
	}
	?>
	<nav class="navigation posts-navigation clearfix" role="navigation">
		<h2 class="screen-reader-text"><?php _e( 'Posts navigation', 'snaps' ); ?></h2>
		<div class="nav-links">

			<?php if ( get_next_posts_link( '', $max_num_pages ) ) : ?>
			<div class="nav-previous">
				<?php
					if ( is_post_type_archive( 'jetpack-portfolio' ) || is_tax( 'jetpack-portfolio-type' ) || is_tax( 'jetpack-portfolio-tag' ) ) {
						next_posts_link( __( 'Older projects', 'snaps' ), $max_num_pages );
					} else {
						next_posts_link( __( 'Older posts', 'snaps' ), $max_num_pages );
					}
				?>
			</div>
			<?php endif; ?>

			<?php if ( get_previous_posts_link( '', $max_num_pages ) ) : ?>
			<div class="nav-next">
				<?php
					if ( is_post_type_archive( 'jetpack-portfolio' ) || is_tax( 'jetpack-portfolio-type' ) || is_tax( 'jetpack-portfolio-tag' ) ) {
						previous_posts_link( __( 'Newer projects', 'snaps' ), $max_num_pages );
					} else {
						previous_posts_link( __( 'Newer posts', 'snaps' ), $max_num_pages );
					}
				?>
			</div>
			<?php endif; ?>

		</div><!-- .nav-links -->
	</nav><!-- .navigation -->
	<?php
}
endif;


if ( ! function_exists( 'the_post_navigation' ) ) :
/**
 * Display navigation to next/previous post when applicable.
 *
 * @todo Remove this function when WordPress 4.3 is released.
 */
function the_post_navigation() {
	// Don't print empty markup if there's nowhere to navigate.
	$previous = ( is_attachment() ) ? get_post( get_post()->post_parent ) : get_adjacent_post( false, '', true );
	$next = get_adjacent_post( false, '', false );

	if ( ! $next && ! $previous ) {
		return;
	}
	?>
	<nav class="navigation post-navigation clearfix" role="navigation">
		<h2 class="screen-reader-text"><?php _e( 'Post navigation', 'snaps' ); ?></h2>
		<div class="nav-links">
			<?php
				previous_post_link( '<div class="nav-previous">%link</div>', '%title' );
				next_post_link( '<div class="nav-next">%link</div>', '%title' );
			?>
		</div><!-- .nav-links -->
	</nav><!-- .navigation -->
	<?php
}
endif;


/**
 * Returns true if a blog has more than 1 category
 */
function snaps_categorized_blog() {
	if ( false === ( $all_the_cool_cats = get_transient( 'all_the_cool_cats' ) ) ) {
		// Create an array of all the categories that are attached to posts
		$all_the_cool_cats = get_categories( array(
			'hide_empty' => 1,
		) );

		// Count the number of categories that are attached to the posts
		$all_the_cool_cats = count( $all_the_cool_cats );

		set_transient( 'all_the_cool_cats', $all_the_cool_cats );
	}

	if ( '1' != $all_the_cool_cats ) {
		// This blog has more than 1 category so snaps_categorized_blog should return true
		return true;
	} else {
		// This blog has only 1 category so snaps_categorized_blog should return false
		return false;
	}
}


/**
 * Flush out the transients used in snaps_categorized_blog
 */
function snaps_category_transient_flusher() {
	// Like, beat it. Dig?
	delete_transient( 'all_the_cool_cats' );
}
add_action( 'edit_category', 'snaps_category_transient_flusher' );
add_action( 'save_post', 'snaps_category_transient_flusher' );


if ( ! function_exists( 'snaps_entry_time_author' ) ) :
/**
* Displays post publish date and author
*/
function snaps_entry_time_author() {
	/* Get the published and update times */
	$time_string = '<time class="entry-date published" datetime="%1$s">%2$s</time>';
	if ( get_the_time( 'U' ) !== get_the_modified_time( 'U' ) ) {
		$time_string .= '<time class="updated" datetime="%3$s">%4$s</time>';
	}

	$time_string = sprintf( $time_string,
		esc_attr( get_the_date( 'c' ) ),
		esc_html( get_the_date() ),
		esc_attr( get_the_modified_date( 'c' ) ),
		esc_html( get_the_modified_date() )
	);

	/* Print date together with author */
	printf( __( '<span class="entry-meta entry-specs">
		<a href="%1$s" title="%2$s" rel="bookmark">%3$s</a>
		<span class="byline"> by
			<span class="author vcard">
				<a class="url fn n" href="%4$s" title="%5$s" rel="author">%6$s</a>
			</span>
		</span>
		</span>', 'snaps' ),
		esc_url( get_permalink() ),
		esc_attr( get_the_time() ),
		$time_string,
		esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ),
		esc_attr( sprintf( __( 'View all posts by %s', 'snaps' ), get_the_author() ) ),
		get_the_author()
	);
}
endif;


if ( ! function_exists( 'snaps_entry_meta' ) ) :
/**
* Displays meta information on posts
*/
function snaps_entry_meta() {

	if ( 'post' == get_post_type() ) {

		/* display published time and author */
		snaps_entry_time_author();

		/* Display categories and tags: */
		/* translators: used between list items, there is a space after the comma */
		$category_list = get_the_category_list( __( ', ', 'snaps' ) );

		/* translators: used between list items, there is a space after the comma */
		$tag_list = get_the_tag_list( '', __( ', ', 'snaps' ) );
		$meta_text = null;
		if ( ! snaps_categorized_blog() ) {
			// This blog only has 1 category so we just need to worry about tags in the meta text
			if ( '' != $tag_list ) {
				$meta_text = __( '<span class="entry-meta meta-tags">Tags: %2$s</span>', 'snaps' );
			}
		} else {
			// But this blog has loads of categories so we should probably display them here
			if ( '' != $tag_list ) {
				$meta_text = __( '<span class="entry-meta meta-catgories">Categories: %1$s</span>', 'snaps' );
				$meta_text .= __( '<span class="entry-meta meta-tags">Tags: %2$s</span>', 'snaps' );
			} else {
				$meta_text = __( '<span class="entry-meta meta-categories">Categories: %1$s</span>', 'snaps' );
			}
		}
		// end check for categories on this blog

		printf(
			$meta_text,
			$category_list,
			$tag_list,
			esc_url( get_permalink() ),
			the_title_attribute( 'echo=0' )
		);
	}
}
endif;
