<?php
/**
 * Jetpack Compatibility File
 * See: http://jetpack.me/
 *
 * @package Snaps
 */

/**
 * Add theme support for Infinite Scroll.
 * See: http://jetpack.me/support/infinite-scroll/
 */
function snaps_jetpack_setup() {
	/**
	 * Adds support for responsive video
	 */
	add_theme_support( 'jetpack-responsive-videos' );

	/**
	 * Adds support for infinite scrolling
	 */
	add_theme_support( 'infinite-scroll', array(
		'container'      => 'posts',
		'footer_widgets' => array( 'sidebar-1', 'sidebar-2', 'sidebar-3', ),
		'footer'         => 'posts',
	) );

	/**
	 * Adds support for site logos
	 */
	add_theme_support( 'site-logo', array(
		'size' => 'snaps-site-logo',
	) );

	/*
	 * Adding theme support for Jetpack Portfolio CPT.
	 * Not essential to add this but this does few nice things.
	 * 1. Turns the CPT on when the theme is activated.
	 * 2. Displays an admin notice if the option is turned off, but the theme is activated.
	 * 3. When the theme is switched away, if no CPTs are populated, it turns it back off.
	 */
	add_theme_support( 'jetpack-portfolio', array(
		'title'          => true,
		'content'        => true,
		'featured-image' => true,
	) );
}
add_action( 'after_setup_theme', 'snaps_jetpack_setup' );

/**
 * Portfolio Title.
 */
function snaps_portfolio_title( $before = '', $after = '' ) {
	$jetpack_portfolio_title = get_option( 'jetpack_portfolio_title' );
	$title = '';

	if ( is_post_type_archive( 'jetpack-portfolio' ) ) {
		if ( isset( $jetpack_portfolio_title ) && '' != $jetpack_portfolio_title ) {
			$title = esc_html( $jetpack_portfolio_title );
		} else {
			$title = post_type_archive_title( '', false );
		}
	} elseif ( is_tax( 'jetpack-portfolio-type' ) || is_tax( 'jetpack-portfolio-tag' ) ) {
		$title = single_term_title( '', false );
	}

	echo $before . $title . $after;
}

/**
 * Portfolio Content.
 */
function snaps_portfolio_content( $before = '', $after = '' ) {
	$jetpack_portfolio_content = get_option( 'jetpack_portfolio_content' );

	if ( is_tax() && get_the_archive_description() ) {
		echo $before . get_the_archive_description() . $after;
	} else if ( isset( $jetpack_portfolio_content ) && '' != $jetpack_portfolio_content ) {
		$content = convert_chars( convert_smilies( wptexturize( stripslashes( wp_filter_post_kses( addslashes( $jetpack_portfolio_content ) ) ) ) ) );
		echo $before . $content . $after;
	}
}

/**
 * Portfolio Featured Image.
 */
function snaps_portfolio_thumbnail( $before = '', $after = '' ) {
	$jetpack_portfolio_featured_image = get_option( 'jetpack_portfolio_featured_image' );

	if ( isset( $jetpack_portfolio_featured_image ) && '' != $jetpack_portfolio_featured_image ) {
		$featured_image = wp_get_attachment_image( (int) $jetpack_portfolio_featured_image, 'post-thumbnail' );
		echo $before . $featured_image . $after;
	}
}
