<?php
/**
 * snaps Theme Customizer
 *
 * @package Snaps
 */

/**
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function snaps_customize_register( $wp_customize ) {

	// Add postMessage support for site title and description for the Theme Customizer.
	$wp_customize->get_setting( 'blogname' )->transport = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport = 'postMessage';

	// Add option to show/hide title and content for portfolio pages
	$wp_customize->add_setting( 'snaps_hide_portfolio_page_content', array(
		'default'           => '',
		'sanitize_callback' => 'snaps_sanitize_checkbox',
	) );

	$wp_customize->add_control( 'snaps_hide_portfolio_page_content', array(
		'label'             => esc_html__( 'Hide title and content on Portfolio Page Template', 'snaps' ),
		'section'           => 'jetpack_portfolio',
		'type'              => 'checkbox',
	) );
}
add_action( 'customize_register', 'snaps_customize_register' );

/**
 * Sanitize the checkbox.
 *
 * @param boolean $input.
 * @return boolean true if portfolio page template displays title and content.
 */
function snaps_sanitize_checkbox( $input ) {
	if ( 1 == $input ) {
		return true;
	} else {
		return false;
	}
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function snaps_customize_preview_js() {
	wp_enqueue_script( 'snaps_customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20120827', true );
}
add_action( 'customize_preview_init', 'snaps_customize_preview_js' );
