<?php
/**
 * Sample implementation of the Custom Header feature
 * http://codex.wordpress.org/Custom_Headers
 *
 * You can add an optional custom header image to header.php like so ...
 *
 * @package Snaps
 */

/**
 * Setup the WordPress core custom header feature.
 *
 * Use add_theme_support to register support for WordPress 3.4+
 * as well as provide backward compatibility for previous versions.
 * Use feature detection of wp_get_theme() which was introduced
 * in WordPress 3.4.
 * *
 *
 * @uses snaps_header_style()
 * @uses snaps_admin_header_style()
 * @uses snaps_admin_header_image()
 *
 * @package Snaps
 */

function snaps_custom_header_setup() {
	$args = array(
		'default-image' => '',
		'default-text-color'  => 'fff',
		'width' => 1200,
		'height' => 500,
		'flex-height' => true,
		'wp-head-callback' => 'snaps_header_style',
		'admin-head-callback' => 'snaps_admin_header_style',
		'admin-preview-callback' => 'snaps_admin_header_image',
	);

	$args = apply_filters( 'snaps_custom_header_args', $args );

	if ( function_exists( 'wp_get_theme' ) ) {
		add_theme_support( 'custom-header', $args );
	}
}
add_action( 'after_setup_theme', 'snaps_custom_header_setup' );


if ( ! function_exists( 'snaps_header_style' ) ) :
/**
 * Styles the header image and text displayed on the blog
 *
 * @see snaps_custom_header_setup().
 */
function snaps_header_style() {
$text_color = get_header_textcolor();

// If no custom color for text is set, let's bail.
if ( display_header_text() && $text_color === get_theme_support( 'custom-header', 'default-text-color' ) ) :
	return;
endif;
?>
<style type="text/css">
<?php
	// Has the text been hidden?
	if ( 'blank' == get_header_textcolor() ) :
?>
	.site-title,
	.site-description {
		position: absolute !important;
		clip: rect(1px 1px 1px 1px); /* IE6, IE7 */
		clip: rect(1px, 1px, 1px, 1px);
	}
<?php
		// If the user has set a custom color for the text use that
		else :
?>
	.site-title a,
	.site-description {
		color: #<?php echo get_header_textcolor(); ?> !important;
	}
<?php endif; ?>
</style>
<?php
}
endif; // snaps_header_style
