<?php
/**
 * The Header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="main">
 *
 * @package Snaps
 */
?><!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>" />
<meta name="viewport" content="width=device-width, initial-scale=1" />
<link rel="profile" href="http://gmpg.org/xfn/11" />
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />

<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<div id="page" class="hfeed site">
	<?php do_action( 'before' ); ?>
	<?php $header_image = get_header_image(); ?>

	<header id="masthead" class="site-header" role="banner" <?php if ( ! empty( $header_image ) ) : ?> style="background-image: url(<?php header_image(); ?>);" <?php endif; ?>>

		<?php /* If there's a background image, use it's size to set a new minimum height for the header */ ?>
		<div class="site-text-contain" <?php if ( ! empty( $header_image ) ) : ?> style="height:<?php echo get_custom_header()->height; ?>px;"<?php endif; ?>>

			<div class="site-text">
				<?php if ( function_exists( 'jetpack_the_site_logo' ) ) :
					jetpack_the_site_logo();
				endif; ?>

				<?php
				if ( is_front_page() && is_home() ) : ?>
					<h1 class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></h1>

				<?php else : ?>
					<p class="site-title"><a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" rel="home"><?php bloginfo( 'name' ); ?></a></p>
				<?php endif; ?>
				<p class="site-description"><?php bloginfo( 'description' ); ?></p>
			</div>

		</div>

		<nav id="anchor" role="navigation" class="site-navigation main-navigation">
			<button class="menu-toggle"><?php _e( 'Menu', 'snaps' ); ?></button>
			<a class="assistive-text skip-link" href="#content" title="<?php esc_attr_e( 'Skip to content', 'snaps' ); ?>"><?php _e( 'Skip to content', 'snaps' ); ?></a>
			<?php wp_nav_menu( array( 'theme_location' => 'primary' ) ); ?>
			<?php
			if ( has_nav_menu( 'social' ) ) :
				wp_nav_menu( array(
					'theme_location' => 'social',
					'depth' => 1,
					'container_class' => 'menu-social-links',
				) );
			endif; ?>
		</nav><!-- .site-navigation .main-navigation -->

	</header><!-- #masthead .site-header -->

	<div id="main" class="site-main">
