<?php
/**
 * @package Snaps
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php
	/**
	 * Featured Thumbnail
	 */
	if ( has_post_thumbnail() ) : ?>
		<div class="featured-image">
			<?php if ( ! is_single() ) : ?>
				<a href="<?php the_permalink(); ?>" rel="bookmark">
			<?php endif;

			the_post_thumbnail();

			if ( ! is_single() ) : ?>
				</a>
			<?php endif; ?>
		</div>
	<?php
	endif;

	/**
 	* Post Title - only for single.php views
	*/
	if ( is_single() ) :
		the_title( '<header class="entry-header"><h1 class="entry-title">', '</h1></header>' );
	endif; ?>

	<div class="entry-content">
		<div class="entry-content-wrap">
			<?php
			/**
		 	* For search results, display an excerpt
			*/
			if ( is_search() ) :
				the_excerpt();

			/**
		 	* Otherwise, display full content
			*/
			else :
				the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'snaps' ) );
				wp_link_pages( array( 'before' => '<div class="page-links">' . __( 'Pages:', 'snaps' ), 'after' => '</div>' ) );
			endif;
			?>
		</div>

		<div class="entry-meta-wrap">
			<?php
			/**
		 	* Post Meta
			*/
			snaps_entry_meta();
			if ( ! post_password_required() && ( comments_open() || '0' != get_comments_number() ) ) : ?>
				<span class="entry-meta comments-link">
					<?php comments_popup_link( __( 'Leave a comment', 'snaps' ), __( '1 Comment', 'spans' ), __( '% Comments', 'spans' ) ); ?>
				</span>
			<?php endif;
			edit_post_link( __( 'Edit', 'snaps' ), '<span class="entry-meta edit-link">', '</span>' );
			?>
		</div><!-- .entry-meta-wrap -->
	</div><!-- .entry-content -->

</article><!-- #post-<?php the_ID(); ?> -->
