<?php
/**
 * The template used for displaying Gallery post formats
 *
 * @package Snaps
 */
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php
	/**
	 * Feature Gallery - for index, archive, search views
	 */
	if ( ! is_single() && get_post_gallery() && ! post_password_required() ) : ?>
		<div class="entry-gallery">
			<?php echo get_post_gallery(); ?>
		</div><!-- .entry-gallery -->

	<?php
	/**
	 * Feature Thumbnail - for single view
	 */
	elseif ( is_single() && has_post_thumbnail() ) : ?>
		<div class="featured-image">
			<?php the_post_thumbnail(); ?>
		</div>
	<?php endif;

	/**
 	* Post Title
	*/
	if ( is_single() ) :
		the_title( '<header class="entry-header"><h1 class="entry-title">', '</h1></header>' );
	else :
		the_title( '<header class="entry-header"><h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2></header>' );
	endif;
	?>

	<div class="entry-content">

		<div class="entry-content-wrap">
			<?php
			/**
		 	* For search results, display an excerpt
			*/
			if ( is_search() ) :
				the_excerpt();

			/**
		 	* Otherwise, display full content
			*/
			else :
				the_content( __( 'Continue reading <span class="meta-nav">&rarr;</span>', 'snaps' ) );
				wp_link_pages( array( 'before' => '<div class="page-links">' . __( 'Pages:', 'snaps' ), 'after' => '</div>' ) );
			endif;
			?>
		</div>

		<div class="entry-meta-wrap">
			<?php
			/**
		 	* Post Meta
			*/
			snaps_entry_meta();
			if ( ! post_password_required() && ( comments_open() || '0' != get_comments_number() ) ) : ?>
				<span class="entry-meta comments-link">
					<?php comments_popup_link( __( 'Leave a comment', 'snaps' ), __( '1 Comment', 'spans' ), __( '% Comments', 'spans' ) ); ?>
				</span>
			<?php endif;
			edit_post_link( __( 'Edit', 'snaps' ), '<span class="entry-meta edit-link">', '</span>' );
			?>
		</div><!-- .entry-meta-wrap -->

	</div><!-- .entry-content -->

</article><!-- #post-<?php the_ID(); ?> -->
