<?php
/**
 * The template for displaying Archive pages.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package Snaps
 */

get_header(); ?>

	<section id="primary" class="content-area">
		<div id="content" class="site-content clearfix" role="main">

		<?php if ( have_posts() ) : ?>

			<header class="page-header">
				<?php the_archive_title( '<h1 class="page-title">', '</h1>' ); ?>
				<?php the_archive_description( '<div class="taxonomy-description">', '</div>' ); ?>
			</header><!-- .page-header -->


			<?php if ( is_post_type_archive( 'jetpack-portfolio' ) || is_tax( 'jetpack-portfolio-type' ) || is_tax( 'jetpack-portfolio-tag' ) ) :
			/**
			 * Loop for Portfolio post types
			 */
			?>
				<div class="posts" id="projects">
					<?php
					while ( have_posts() ) : the_post();
						get_template_part( 'content', 'portfolio' );
					endwhile;
					?>
				</div>

			<?php
			else :
			/**
			 * Loop for all other post types
			 */
			?>
				<div class="archive-posts posts" id="posts">
					<?php
					while ( have_posts() ) : the_post();
						get_template_part( 'content', get_post_format() );
					endwhile;
					?>
				</div>

			<?php
			endif;

			snaps_paging_nav();

		else :

			get_template_part( 'content-none', 'index' );

		endif;
		?>

		</div><!-- #content .site-content -->
	</section><!-- #primary .content-area -->

<?php get_footer(); ?>
