<?php
/**
 * The template for displaying 404 pages (Not Found).
 *
 * @package Snaps
 */

get_header(); ?>

	<div id="primary" class="content-area">
		<div id="content" class="site-content clearfix" role="main">

			<article id="post-0" class="post error404 not-found">
				<header class="entry-header">
					<h1 class="entry-title"><?php _e( 'Oops! That page can&rsquo;t be found.', 'snaps' ); ?></h1>
				</header><!-- .entry-header -->

				<div class="entry-content">
					<p><?php _e( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'snaps' ); ?></p>

					<?php get_search_form(); ?>

					<?php the_widget( 'WP_Widget_Recent_Posts', '', 'before_title=<h4>&after_title=</h4>' ); ?>

					<?php if ( snaps_categorized_blog() ) : // Only show the widget if site has multiple categories. ?>
					<div class="widget widget_categories">
						<h4 class="widget-title"><?php _e( 'Most Used Categories', 'snaps' ); ?></h4>
						<ul>
						<?php
							wp_list_categories( array(
								'orderby'    => 'count',
								'order'      => 'DESC',
								'show_count' => 1,
								'title_li'   => '',
								'number'     => 10,
							) );
						?>
						</ul>
					</div><!-- .widget -->
					<?php endif; ?>

					<?php
						$archive_content = '<p>' . __( 'Try looking in the monthly archives.', 'snaps' ) . '</p>';
						the_widget( 'WP_Widget_Archives', 'dropdown=1', "before_title=<h4>&after_title=</h4>$archive_content" );
					?>

					<?php the_widget( 'WP_Widget_Tag_Cloud', '', 'before_title=<h4>&after_title=</h4>' ); ?>

				</div><!-- .entry-content -->
			</article><!-- #post-0 .post .error404 .not-found -->

		</div><!-- #content .site-content -->
	</div><!-- #primary .content-area -->

<?php get_footer(); ?>
